/*
 * Protocol independent interface for GM
 */
#include <unistd.h>
#include <stdio.h>
#include <errno.h>
#include <pthread.h>
#include <ctype.h>
#include <poll.h>

#include "libfma.h"
#include "libmyri.h"

struct myri_event Null_event;		/* used for returning NO_EVENT */
int Pipe[2];

/*
 * Instantiate the myri_ interface
 */
int
myri_open(
  int nic_id)
{
  int rc;

  if (nic_id != 0) return -1;		/* only one NIC */

  rc = pipe(Pipe);
  if (rc == -1) return -1;

  /* initialize null event */
  Null_event.type = MYRI_EVENT_NO_EVENT;

  /* use the nic_id as a handle for future calls */
  return 0;
}


/*
 * Close a myri instance
 */
void
myri_close(
  int nic_id)
{
}

/*
 * Return the file descriptor associated with a myri handle
 */
int
myri_fd(
  int nic_id)
{
  return Pipe[0];
}

/*
 * Get the next event from the GM thread
 */
int
myri_next_event(
  int nic_id,
  struct myri_event **rep,
  int timeout)
{
  /*
   * If a non-negative timeout is specified, poll on the pipe for
   * that long and return NO_EVENT if timeout occurs
   */
  if (timeout >= 0) {
    struct pollfd pf;
    int rc;

    /* execute a poll() with appropriate timeout */
    pf.fd = Pipe[0];
    pf.events = POLLIN;
    rc = poll(&pf, 1, timeout);

    /* bad if error and not EINTR */
    if (rc == -1 && errno != EINTR
#if HAVE_DECL_ERESTART
	&& errno != ERESTART
#endif
	&& errno != EAGAIN) {
      return -1;
    }
  }

    /* return of 0 from poll means nothing is ready */
  *rep = &Null_event;
  return 0;
}


/*
 * Release an event struct returned by myri_next_event
 */
void
myri_release_event(
  struct myri_event *mep)
{
}

/*
 * Perform a raw send
 */
int
myri_raw_send(
  int nic_id,
  int ifc,
  void *route,
  int route_len,
  void *txbuf,
  int txlen,
  void *context)
{
  return 0;
}

/*
 * Get the hostname of a remote host.  If the hostname is returned as ending
 * in ":X" then trim the ":X" and use X and remote nic_id, else remote nic_id
 * is 0.
 */
int
myri_mac_to_hostname(
  int nic_id,
  lf_mac_addr_t mac_addr,
  lf_string_t hostname,
  int *his_nic_id)
{
  strcpy(hostname, "somehost");
  return 0;
}

/*
 * Return information about this NIC
 */
int
myri_get_nic_info(
  int nic_id,
  struct myri_nic_info *nip)
{
  /* get MAC address */
  nip->mac_addr[0] = 0x00;
  nip->mac_addr[1] = 0x60;
  nip->mac_addr[2] = 0xdd;
  nip->mac_addr[3] = 0x48;
  nip->mac_addr[4] = 0x31;
  nip->mac_addr[5] = 0x32;

  return 0;
}

int myri_set_route_start(
  int nic_id)
{
  return 0;
}

int myri_set_route_end(
  int nic_id,
  lf_mac_addr_t mapper_mac,
  int map_version,
  int num_hosts)
{
  return 0;
}

/*
 * Set a route
 */
int
myri_set_route(
  int nic_id,
  lf_mac_addr_t remote_mac,
  enum lf_firmware_type fw_type,
  int remote_ifc,
  int route_num,
  int local_ifc,
  unsigned char *route,
  int route_len)
{
  return 0;
}

/*
 * Return counters for a NIC port
 */
int
myri_get_nic_counters(
  int nic_id,
  int port,
  struct myri_nic_counters *counters)
{
  memset(counters, 0, sizeof(counters));
  return 0;
}

/*
 * Return firmware code
 */
enum lf_firmware_type
myri_firmware_type()
{
  return MYRI_FW_UNKNOWN;
}

/*
 * set info for NIC auto-reply to scouts if supported
 */
int
myri_set_nic_reply_info(
  int nic_id,
  void *blob,
  int size)
{
  return 0;
}
